/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class McLogsAntiVersionCensorer {
    private static final char SAFE_DOT = '\u2219';
    private static final Pattern DOTTED_CHAIN = Pattern.compile("(?<!\\d)(?:\\d{1,3}\\.){3,}\\d{1,3}(?!\\d)");
    private static volatile Map<String, String> IP_LIKE_VERSION_REPLACEMENTS = null;

    private McLogsAntiVersionCensorer() {
    }

    public static synchronized String apply(String text) {
        if (!CrashAssistantConfig.getBoolean((String)"general.enable_mclogs_anti_ip_like_version_censorer")) {
            return text;
        }
        if (text == null || text.isEmpty()) {
            return text;
        }
        McLogsAntiVersionCensorer.ensureBuilt();
        String out = text;
        for (Map.Entry<String, String> e : IP_LIKE_VERSION_REPLACEMENTS.entrySet()) {
            out = out.replace(e.getKey(), e.getValue());
        }
        return out;
    }

    public static synchronized void computeIpLikeVersions() {
        McLogsAntiVersionCensorer.buildMap();
    }

    public static Map<String, String> getIpLikeVersionReplacements() {
        return IP_LIKE_VERSION_REPLACEMENTS;
    }

    private static void ensureBuilt() {
        if (IP_LIKE_VERSION_REPLACEMENTS == null) {
            McLogsAntiVersionCensorer.buildMap();
        }
    }

    private static void buildMap() {
        LinkedHashSet chains = new LinkedHashSet();
        Consumer<Mod> visit = mod -> {
            if (mod == null) {
                return;
            }
            McLogsAntiVersionCensorer.collectChains(McLogsAntiVersionCensorer.nz(mod.getVersion()), chains);
            McLogsAntiVersionCensorer.collectChains(McLogsAntiVersionCensorer.nz(mod.getJarName()), chains);
        };
        LinkedHashSet roots = ModListUtils.getCurrentModList((boolean)true);
        if (roots != null) {
            for (Mod m : roots) {
                McLogsAntiVersionCensorer.traverseDepthFirst(m, visit);
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(Math.max(16, chains.size() * 2));
        for (String chain : chains) {
            map.put(chain, McLogsAntiVersionCensorer.maskAllDots(chain));
        }
        IP_LIKE_VERSION_REPLACEMENTS = Collections.unmodifiableMap(map);
        CrashAssistantApp.LOGGER.info("IP-like version replacements computed: {}", IP_LIKE_VERSION_REPLACEMENTS.keySet());
    }

    private static void traverseDepthFirst(Mod mod, Consumer<Mod> visitor) {
        if (mod == null) {
            return;
        }
        visitor.accept(mod);
        List kids = mod.getJarJarMods();
        if (kids != null && !kids.isEmpty()) {
            for (Mod child : kids) {
                McLogsAntiVersionCensorer.traverseDepthFirst(child, visitor);
            }
        }
    }

    private static void collectChains(String s, Set<String> out) {
        if (s == null || s.isEmpty()) {
            return;
        }
        Matcher m = DOTTED_CHAIN.matcher(s);
        while (m.find()) {
            out.add(m.group());
        }
    }

    private static String maskAllDots(String chain) {
        return chain.replace('.', '\u2219');
    }

    private static String nz(String v) {
        return v == null ? "" : v;
    }
}

